### R code from vignette source 'DiffBind.Rnw'

###################################################
### code chunk number 1: DiffBind.Rnw:98-103
###################################################
tmp =  tempfile(as.character(Sys.getpid()))
pdf(tmp)
savewarn = options("warn")
options(warn=-1)
savewd = getwd()


###################################################
### code chunk number 2: DiffBind.Rnw:106-108
###################################################
library(DiffBind)
setwd(system.file("extra", package="DiffBind"))


###################################################
### code chunk number 3: DiffBind.Rnw:113-118 (eval = FALSE)
###################################################
## tamoxifen = dba(sampleSheet="tamoxifen.csv")
## tamoxifen = dba.count(tamoxifen)
## tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)
## tamoxifen = dba.analyze(tamoxifen)
## tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 4: DiffBind.Rnw:150-151
###################################################
tamoxifen = dba(sampleSheet="tamoxifen.csv")


###################################################
### code chunk number 5: DiffBind.Rnw:156-157
###################################################
tamoxifen


###################################################
### code chunk number 6: DiffBind.Rnw:165-166 (eval = FALSE)
###################################################
## plot(tamoxifen)


###################################################
### code chunk number 7: DiffBind.Rnw:182-183 (eval = FALSE)
###################################################
## tamoxifen = dba.count(tamoxifen, minOverlap=3) 


###################################################
### code chunk number 8: DiffBind.Rnw:186-187
###################################################
data(tamoxifen_counts)


###################################################
### code chunk number 9: DiffBind.Rnw:196-197
###################################################
tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)


###################################################
### code chunk number 10: DiffBind.Rnw:217-218
###################################################
tamoxifen = dba.analyze(tamoxifen) 


###################################################
### code chunk number 11: DiffBind.Rnw:224-225
###################################################
tamoxifen    


###################################################
### code chunk number 12: DiffBind.Rnw:237-238
###################################################
tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 13: DiffBind.Rnw:243-244
###################################################
tamoxifen.DB


###################################################
### code chunk number 14: DiffBind.Rnw:263-264
###################################################
dba.plotMA(tamoxifen)


###################################################
### code chunk number 15: DiffBind.Rnw:283-284
###################################################
dba.plotPCA(tamoxifen,DBA_CONDITION)


###################################################
### code chunk number 16: DiffBind.Rnw:303-304
###################################################
dba.plotPCA(tamoxifen, contrast=1,th=.05)


###################################################
### code chunk number 17: DiffBind.Rnw:319-321
###################################################
sum(tamoxifen.DB$Fold<0)
sum(tamoxifen.DB$Fold>0)


###################################################
### code chunk number 18: DiffBind.Rnw:326-327
###################################################
pvals = dba.plotBox(tamoxifen)


###################################################
### code chunk number 19: DiffBind.Rnw:341-342
###################################################
pvals


###################################################
### code chunk number 20: DiffBind.Rnw:358-359
###################################################
corvals = dba.plotHeatmap(tamoxifen)


###################################################
### code chunk number 21: DiffBind.Rnw:366-367
###################################################
corvals = dba.plotHeatmap(tamoxifen, contrast=1, correlations=FALSE)


###################################################
### code chunk number 22: DiffBind.Rnw:388-391
###################################################
data(tamoxifen_counts)
tamoxifen = dba.contrast(tamoxifen,categories=DBA_CONDITION,
                         block=tamoxifen$masks$MCF7)


###################################################
### code chunk number 23: DiffBind.Rnw:396-398
###################################################
tamoxifen = dba.analyze(tamoxifen)
tamoxifen


###################################################
### code chunk number 24: DiffBind.Rnw:403-404
###################################################
dba.plotMA(tamoxifen,method=DBA_EDGER_BLOCK)


###################################################
### code chunk number 25: DiffBind.Rnw:419-421
###################################################
dba.plotHeatmap(tamoxifen,contrast=1,method=DBA_EDGER_BLOCK,
                attributes=c(DBA_TISSUE,DBA_CONDITION,DBA_REPLICATE))


###################################################
### code chunk number 26: DiffBind.Rnw:424-426
###################################################
dba.plotPCA(tamoxifen,contrast=1,method=DBA_EDGER_BLOCK,
            attributes=c(DBA_TISSUE,DBA_CONDITION))


###################################################
### code chunk number 27: DiffBind.Rnw:446-448
###################################################
tamoxifen = dba.analyze(tamoxifen,method=DBA_DESEQ)
tamoxifen


###################################################
### code chunk number 28: DiffBind.Rnw:457-458
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 29: DiffBind.Rnw:465-467
###################################################
olap.rate = dba.overlap(tamoxifen,mode=DBA_OLAP_RATE)
olap.rate


###################################################
### code chunk number 30: DiffBind.Rnw:475-476
###################################################
plot(olap.rate,type='b',ylab='# peaks', xlab='Overlap at least this many peaksets') 


###################################################
### code chunk number 31: DiffBind.Rnw:494-495
###################################################
names(tamoxifen$masks)


###################################################
### code chunk number 32: DiffBind.Rnw:500-502
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive,
            mode=DBA_OLAP_RATE)


###################################################
### code chunk number 33: DiffBind.Rnw:509-510
###################################################
dba.plotVenn(tamoxifen, tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive)


###################################################
### code chunk number 34: DiffBind.Rnw:524-527
###################################################
tamoxifen = dba.peakset(tamoxifen, consensus = c(DBA_TISSUE,DBA_CONDITION), 
            minOverlap=0.66)
tamoxifen


###################################################
### code chunk number 35: DiffBind.Rnw:535-537
###################################################
tamoxifen_consensus = dba(tamoxifen, mask = tamoxifen$masks$Consensus)
tamoxifen_consensus


###################################################
### code chunk number 36: DiffBind.Rnw:553-556 (eval = FALSE)
###################################################
## data(tamoxifen_peaks)
## tamoxifen = dba.peakset(tamoxifen, consensus = DBA_TISSUE, minOverlap=0.66)
## dba.plotVenn(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 37: DiffBind.Rnw:565-566
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 38: DiffBind.Rnw:571-573
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$Resistant,mode=DBA_OLAP_RATE)
dba.overlap(tamoxifen,tamoxifen$masks$Responsive,mode=DBA_OLAP_RATE)


###################################################
### code chunk number 39: DiffBind.Rnw:581-583
###################################################
tamoxifen = dba.peakset(tamoxifen, consensus =  DBA_CONDITION, minOverlap = 0.33)
dba.plotVenn(tamoxifen,tamoxifen$masks$Consensus)


###################################################
### code chunk number 40: DiffBind.Rnw:595-596
###################################################
tamoxifen.OL = dba.overlap(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 41: DiffBind.Rnw:601-603
###################################################
tamoxifen.OL$onlyA
tamoxifen.OL$onlyB


###################################################
### code chunk number 42: DiffBind.Rnw:615-620
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$Consensus, 
            minOverlap=1,sampID="OL Consensus")
tamoxifen = dba.peakset(tamoxifen,!tamoxifen$masks$Consensus,
            minOverlap=3,sampID="Consensus_3") 
dba.plotVenn(tamoxifen,14:15)


###################################################
### code chunk number 43: DiffBind.Rnw:635-636
###################################################
data(tamoxifen_analysis)


###################################################
### code chunk number 44: DiffBind.Rnw:641-642
###################################################
tamoxifen.rep = dba.report(tamoxifen,bCalled=T,th=1)


###################################################
### code chunk number 45: DiffBind.Rnw:647-653
###################################################
onlyResistant = tamoxifen.rep$Called1>=2 & tamoxifen.rep$Called2<3
sum(onlyResistant )
onlyResponsive = tamoxifen.rep$Called2>=3 &  tamoxifen.rep$Called1<2
sum(onlyResponsive)
bothGroups = tamoxifen.rep$Called1>= 2 & tamoxifen.rep$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 46: DiffBind.Rnw:664-671
###################################################
tamoxifen.DB = dba.report(tamoxifen,bCalled=T,th=.1)
onlyResistant = tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2<3
sum(onlyResistant)
onlyResponsive = tamoxifen.DB$Called2>=3 & tamoxifen.DB$Called1<2
sum(onlyResponsive)
bothGroups = tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 47: DiffBind.Rnw:764-765 (eval = FALSE)
###################################################
## source(file.path(system.file("extra", package="DiffBind"),"tamoxifen_GEO.R"))


###################################################
### code chunk number 48: DiffBind.Rnw:772-773 (eval = FALSE)
###################################################
## cat(file.path(system.file("extra", package="DiffBind"),"tamoxifen_GEO.csv"))


###################################################
### code chunk number 49: setup
###################################################
sessionInfo()


###################################################
### code chunk number 50: DiffBind.Rnw:788-791
###################################################
dev.off()
unlink(tmp)
setwd(savewd)


